/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.dischargelamps.model;

import edu.colorado.phet.common.quantum.model.Atom;
import edu.colorado.phet.common.quantum.model.AtomicState;
import edu.colorado.phet.dischargelamps.model.DischargeLampAtom;
import edu.colorado.phet.dischargelamps.model.EnergyAbsorptionStrategy;
import edu.colorado.phet.dischargelamps.quantum.model.Electron;
import java.util.Random;

public class EqualLikelihoodAbsorptionStrategy
extends EnergyAbsorptionStrategy {
    private static Random random = new Random();

    public void collideWithElectron(Atom atom, Electron electron) {
        int n;
        int n2;
        AtomicState[] atomicStateArray = atom.getStates();
        AtomicState atomicState = atom.getCurrState();
        double d = EqualLikelihoodAbsorptionStrategy.getElectronEnergyAtCollision((DischargeLampAtom)atom, electron);
        for (n2 = 0; n2 < atomicStateArray.length && atomicStateArray[n2] != atomicState; ++n2) {
        }
        for (n = n2 + 1; n < atomicStateArray.length && !(atomicStateArray[n].getEnergyLevel() - atomicState.getEnergyLevel() > d); ++n) {
        }
        if (--n > n2) {
            int n3 = random.nextInt(n - n2) + 1;
            int n4 = n3 + n2;
            AtomicState atomicState2 = atomicStateArray[n4];
            double d2 = atomicState2.getEnergyLevel() - atomicState.getEnergyLevel();
            atom.setCurrState(atomicState2);
            electron.setEnergy(d - d2);
        }
    }
}

